<title>Ads List - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
<style>
    .table th {
        background-color: rgba(250, 250, 250, 1); 
        color: #000066; 
        font-size: 12px;
    }
    
    .table-no-vertical-border th,
    .table-no-vertical-border td {
        border-left: none;  
        border-right: none; 
        border-color: rgba(0, 0, 0, 0.1); 
    }
    .table td {
        font-size: 14px;
        color: #000;
    }
</style>
@endsection
@section('user-content')
<div class="card mt-2">
    <div class="card-header">
        <div class="card-title text-center" style="font-weight: 500; color: #2ECC71; font-size: 20px;">Ads History</div>
    </div>
    <div class="card-body">
        <div class="table-responsive active">
            @if ($datas->isEmpty())
                <div class="text-center py-3">
                    <p>You Have No Ads</p>
                </div>
            @else
                <table class="table table-bordered text-nowrap table-no-vertical-border table-flush" id="example1">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col border-bottom-0" width="5%">CAMPAIGN ID</th>
                            <th scope="col border-bottom-0" width="15%">Banner</th>
                            <th scope="col border-bottom-0">TITLE</th>
                            <th scope="col border-bottom-0">TARGET</th>
                            <th scope="col border-bottom-0" width="8%">DURATION & COST</th>
                            <th scope="col border-bottom-0">Reason/Remark</th>
                            <th scope="col border-bottom-0" width="8%">STATUS</th>
                            <th scope="col border-bottom-0" width="8%">DATE</th>
                            <th scope="col border-bottom-0" width="8%">ENDING</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $key => $data)
                            <tr>
                                <td>{{ $data->id }}</td>
                                <td><img src="{{ URL::to($data->image) }}" width="120" alt="" class="c-pointer" onclick="viewImage('{{URL::to($data->data)}}')"></td>
                                <td>{{ $data->title }}</td>
                                <td>{{ $data->link }}</td>
                                <td>{{ $data->duration }} DAYS, ${{ $data->cost }}</td>
                                <td>{{ $data->reason }}</td>
                                <td>
                                    @if ($data->approval == 2)
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-red"></i>
                                            <span class="text-black">Rejected</span>
                                        </span>
                                    @elseif ($data->exp_date < date('Y-m-d'))
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-blue"></i>
                                            <span class="text-black">Completed</span>
                                        </span>
                                    @else
                                        @if($data->approval == 1)
                                            <span class="badge badge-dot mr-4">
                                                <i class="bg-gradient-green"></i>
                                                <span class="text-black">Approved</span>
                                            </span>
                                        @else
                                            <span class="badge badge-dot mr-4">
                                                <i style="background-color: #F1C40F;"></i>
                                                <span class="text-black">Pending</span>
                                            </span>
                                        @endif
                                    @endif

                                </td>
                                <td>{{ \Carbon\Carbon::parse($data->created_at)->format('j M y') }}</td>

                                <td>{{ \Carbon\Carbon::parse($data->exp_date)->format('j M y') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>



    <div class="row justify-content-center">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="h3 mb-0">Ads History</h5>
                </div>

            <div class="card-body p-0">
                @if ($datas->isEmpty())
                    <div class="text-center py-3">
                        <p>You Have No Ads</p>
                    </div>
                @else

                    <ul class="list-group list-group-flush" data-toggle="checklist">

                    @foreach ($datas as $key => $data)
                        @if ($data->approval == 1)    
                            <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                <div class="checklist-item checklist-item-success">
                                    <div class="checklist-info">
                                        <h5 class="checklist-title mb-0">{{ $data->title }}</h5>
                                        <small>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y g:i A')}}</small>
                                    </div>
                        @elseif ($data->approval == 2)
                            <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                <div class="checklist-item checklist-item-danger">
                                    <div class="checklist-info">
                                        <h5 class="checklist-title mb-0">{{ $data->title }}</h5>
                                        <small>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y g:i A')}}</small>
                                    <div class="checklist-info">
                                        <small>Reason: {{ $data->reason }}</small>
                                    </div>
                                    </div>
                        @else
                            <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                <div class="checklist-item checklist-item-warning">
                                    <div class="checklist-info">
                                        <h5 class="checklist-title mb-0">{{ $data->title }}</h5>
                                        <small>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y g:i A') }}</small>
                                    </div>
                        @endif
                                    <div>
                                       <h5><b> <div style="color:#1D8348";>
                                            {{ $data->cost }} $ 
                                        </div></b></h5>
                                    </div>
                                </div>
                            </li>
                            
                    @endforeach
                    </ul>
                @endif
                </div>
            </div>
        </div>
    </div>-->

@endsection
@section('js')
    <script>
        function setAccount(account_id) {
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "{{ route('user.deposit-account-info') }}",
                type: "POST",
                data: {
                    _token: '{{ csrf_token() }}',
                    account_id: account_id,
                },
                success: function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: ' + data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }

    </script>
@endsection
